"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
const chokidar = __importStar(require("chokidar"));
const index_js_1 = __importDefault(require("./../build/index.js"));
const index_js_2 = __importDefault(require("./../loger/index.js"));
const utils = __importStar(require("./../utils/index.js"));
const index_js_3 = __importDefault(require("./../lang/index.js"));
class Dev {
    cwd;
    baseDir;
    build;
    isBuilding = false;
    pending = false;
    constructor(cwd, baseDir) {
        this.cwd = cwd;
        this.baseDir = baseDir;
        this.build = new index_js_1.default(cwd, baseDir);
    }
    async start() {
        index_js_2.default.i("Dev", index_js_3.default.dev?.start || "开始即时监听构建");
        await this.build.build();
        this.startWatcher();
    }
    startWatcher() {
        const watchPath = this.cwd;
        const watcher = chokidar.watch(watchPath, {
            ignoreInitial: true,
            ignored: [
                "**/dist/**",
                "**/.git/**",
                "**/node_modules/**",
                "**/lib/data/cache/**",
                "dist/**"
            ],
            persistent: true,
            usePolling: true,
            interval: 150
        });
        watcher.on("all", async (event, filePath) => {
            index_js_2.default.i("Dev", `${index_js_3.default.dev?.tip || "监听到变化"} ${event} ${filePath}`);
            if (this.isBuilding) {
                this.pending = true;
                return;
            }
            await this.rebuild();
        });
    }
    async rebuild() {
        this.isBuilding = true;
        try {
            index_js_2.default.i("Dev", index_js_3.default.dev?.start_d || "开始增量构建");
            await this.build.build();
        }
        catch (err) {
            index_js_2.default.e("Dev", (index_js_3.default.err_bulid || "构建错误") + utils.toString(err));
        }
        this.isBuilding = false;
        if (this.pending) {
            this.pending = false;
            await this.rebuild();
        }
    }
}
module.exports = async (workDir, baseDir) => new Dev(workDir, baseDir).start();
