"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const promises_1 = __importDefault(require("fs/promises"));
const utils = __importStar(require("../utils/index.js"));
class SecurityFile {
    #dir = null;
    constructor(dir) {
        this.#dir = dir;
    }
    #getDir(d) {
        const dir = utils.join(this.#dir, d);
        if (!dir.startsWith(this.#dir))
            throw new Error("[Mbler security] Don't into Parent Directory");
        return dir;
    }
    async mkdir(DirName) {
        try {
            await promises_1.default.mkdir(this.#getDir(DirName), {
                recursive: true
            });
            return true;
        }
        catch {
            return false;
        }
    }
    async rm(File) {
        try {
            await promises_1.default.rm(this.#getDir(File), {
                recursive: true,
                force: true
            });
            return true;
        }
        catch (err) {
            return false;
        }
    }
    async writeFile(File, content) {
        try {
            await promises_1.default.writeFile(this.#getDir(File), content, {
                encoding: 'utf-8'
            });
            return true;
        }
        catch (err) {
            return false;
        }
    }
    async readFile(File, opt) {
        return await utils.readFile(this.#getDir(File), opt);
    }
    async readdir(Dir) {
        return await promises_1.default.readdir(this.#getDir(Dir));
    }
}
exports.default = SecurityFile;
