"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const promises_1 = __importDefault(require("node:fs/promises"));
const node_path_1 = __importDefault(require("node:path"));
// 用于给 Temp 提供不需要导入 fs 的小支持
// 一些时候直接 Temp.dir 作为目录完事
class FileMethod {
    dir = "";
    #getDir(Dir) {
        return node_path_1.default.join(this.dir, Dir);
    }
    async mkdir(DirName) {
        try {
            await promises_1.default.mkdir(this.#getDir(DirName), {
                recursive: true
            });
            return true;
        }
        catch {
            return false;
        }
    }
    async rm(File) {
        try {
            await promises_1.default.rm(this.#getDir(File), {
                recursive: true,
                force: true
            });
            return true;
        }
        catch (err) {
            return false;
        }
    }
    async writeFile(File, content) {
        try {
            await promises_1.default.writeFile(this.#getDir(File), content);
            return true;
        }
        catch (err) {
            return false;
        }
    }
    readFile(File) {
        return promises_1.default.readFile(this.#getDir(File));
    }
    async readdir(Dir) {
        return await promises_1.default.readdir(this.#getDir(Dir));
    }
}
exports.default = FileMethod;
