"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GameLib = void 0;
const event_js_1 = require("./event.js");
const loger_js_1 = require("./loger.js");
const entity_js_1 = require("./entity.js");
const ui_js_1 = require("./ui.js");
class GameLib {
    regLayout = ui_js_1.regLayout;
    constructor(isLoger = true) {
        this.loger = isLoger ? loger_js_1.loger : loger_js_1.emtpyloger;
        // 访问时是 Object 对象
        this.event = new event_js_1.event(this.loger);
        //  访问时是 Function 对象
        this.entity = (rawEntity) => new entity_js_1.Entity(this.loger, rawEntity);
        this.createForm = (name, opt) => (0, ui_js_1.createForm)(this.loger, name, opt);
        this.loger.w(`gameLib 模块加载成功`);
    }
}
exports.GameLib = GameLib;
