"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Logger = exports.logLevel = void 0;
const config_js_1 = require("../config.js");
(function (logLevel) {
    logLevel[logLevel["debug"] = 0] = "debug";
    logLevel[logLevel["log"] = 1] = "log";
    logLevel[logLevel["warn"] = 2] = "warn";
    logLevel[logLevel["error"] = 3] = "error";
})(exports.logLevel || (exports.logLevel = {}));
class Logger {
    name;
    constructor(name) {
        this.name = name;
    }
    get logLevel() {
        return config_js_1.SAPIGameConfig.config.logLevel;
    }
    debug(message, ...optionalParams) {
        if (this.logLevel <= exports.logLevel.debug)
            console.log(`<Game-debug>[${this.name}] ${message}`, ...optionalParams);
    }
    log(message, ...optionalParams) {
        if (this.logLevel <= exports.logLevel.log)
            console.log(`<Game-log>[${this.name}] ${message}`, ...optionalParams);
    }
    warn(message, ...optionalParams) {
        if (this.logLevel <= exports.logLevel.warn)
            console.warn(`<Game-warn>[${this.name}] ${message}`, ...optionalParams);
    }
    /**
     * 打印错误信息
     * @param message 消息
     * @param e 错误
     */
    error(message, e) {
        if (this.logLevel > exports.logLevel.error)
            return;
        if (e instanceof Error) {
            console.error(`<Game-error>[${this.name}] ${message}`, e, e.stack);
        }
        else {
            console.error(`<Game-error>[${this.name}] ${message}`, e);
        }
    }
}
exports.Logger = Logger;
