"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.regGameCommand = regGameCommand;
const server_1 = require("@minecraft/server");
const main_js_1 = require("../main.js");
const vanila_data_js_1 = require("../utils/vanila-data.js");
const config_js_1 = require("../config.js");
function regGameCommand(customCommandRegistry) {
    //注册枚举
    customCommandRegistry.registerEnum("game:opreation", [
        "start",
        "stop",
        "stopAll",
        "status",
        "end",
    ]);
    //注册命令
    customCommandRegistry.registerCommand({
        name: "game:game",
        description: "SAPI-Game命令操作",
        permissionLevel: server_1.CommandPermissionLevel.GameDirectors,
        mandatoryParameters: [
            {
                name: "game:opreation",
                type: server_1.CustomCommandParamType.Enum,
            },
        ],
        optionalParameters: [
            { name: "gameName", type: server_1.CustomCommandParamType.String },
            { name: "gameTag", type: server_1.CustomCommandParamType.String },
        ],
    }, (origin, ope, name, tag) => {
        return handleCommand(origin, ope, name, tag);
    });
    customCommandRegistry.registerCommand({
        name: "game:hub",
        description: "SAPI-Game返回主城命令",
        permissionLevel: server_1.CommandPermissionLevel.Any,
    }, (origin) => {
        if (origin.sourceEntity?.typeId != vanila_data_js_1.EntityTypeIds.Player)
            return {
                message: "必须是玩家执行",
                status: server_1.CustomCommandStatus.Failure,
            };
        main_js_1.Game.playerManager.forceReleaseFromGame(origin.sourceEntity.id);
        server_1.system.run(() => {
            config_js_1.SAPIGameConfig.config.hub(origin.sourceEntity);
        });
        return { message: "", status: server_1.CustomCommandStatus.Success };
    });
    customCommandRegistry.registerCommand({
        name: "game:l",
        description: "SAPI-Game返回主城命令",
        permissionLevel: server_1.CommandPermissionLevel.Any,
    }, (origin) => {
        if (origin.sourceEntity?.typeId != vanila_data_js_1.EntityTypeIds.Player)
            return {
                message: "必须是玩家执行",
                status: server_1.CustomCommandStatus.Failure,
            };
        main_js_1.Game.playerManager.forceReleaseFromGame(origin.sourceEntity.id);
        server_1.system.run(() => {
            config_js_1.SAPIGameConfig.config.hub(origin.sourceEntity);
        });
        return { message: "", status: server_1.CustomCommandStatus.Success };
    });
}
function handleCommand(origin, ope, name, tag) {
    const player = origin.sourceEntity instanceof server_1.Player ? origin.sourceEntity : undefined;
    switch (ope) {
        case "stopAll":
            server_1.system.run(() => {
                main_js_1.Game.manager.stopAll();
            });
            return {
                message: "已停止所有运行中的游戏",
                status: server_1.CustomCommandStatus.Success,
            };
        case "status":
            main_js_1.Game.manager.status(player, name === "detail");
            break;
        case "stop":
            if (name) {
                const key = `${name}:${tag ?? 0}`;
                const engine = main_js_1.Game.manager.getGameByKey(key);
                if (!engine)
                    return {
                        message: "游戏不存在",
                        status: server_1.CustomCommandStatus.Failure,
                    };
                server_1.system.run(() => {
                    main_js_1.Game.manager.stopGameByKey(key);
                });
                return {
                    message: `已停止游戏: ${key}`,
                    status: server_1.CustomCommandStatus.Success,
                };
            }
            break;
        case "end":
            server_1.system.run(() => {
                main_js_1.Game.manager.end();
            });
            break;
    }
    return undefined;
}
