"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GameStructure = void 0;
const server_1 = require("@minecraft/server");
const vanila_data_js_1 = require("../utils/vanila-data.js");
/**游戏结构 */
class GameStructure {
    id;
    dim;
    loc;
    /**
     * 构造一个游戏结构
     * @param id 结构id
     * @param loc 结构放置坐标
     * @param dim 结构维度(默认主世界)
     */
    constructor(id, loc, dim = vanila_data_js_1.DimensionIds.Overworld) {
        this.id = id;
        this.dim = dim;
        this.loc = loc;
    }
    /**获取结构 */
    get() {
        return server_1.world.structureManager.get(this.id);
    }
    /**放在默认的位置 */
    place(options) {
        const dim = server_1.world.getDimension(this.dim);
        server_1.world.structureManager.place(this.id, dim, this.loc, options);
    }
    /**放在指定地点 */
    placeOn(loc, dim, options) {
        server_1.world.structureManager.place(this.id, dim, loc, options);
    }
}
exports.GameStructure = GameStructure;
