"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ComponentDeleteFailedError = exports.ComponentLoadFailedError = exports.GameComponentAlreadyExistsError = exports.GameComponentNotExistsError = void 0;
const GameError_js_1 = require("../utils/GameError.js");
class GameComponentNotExistsError extends GameError_js_1.GameStateError {
    constructor(componentType, tag, options) {
        const msg = tag
            ? `组件 ${componentType.name} (tag=${tag}) 不存在于当前状态中`
            : `组件 ${componentType.name} 不存在于当前状态中`;
        super(msg, options);
    }
}
exports.GameComponentNotExistsError = GameComponentNotExistsError;
// 组件已存在
class GameComponentAlreadyExistsError extends GameError_js_1.GameStateError {
    constructor(componentType, tag, options) {
        const msg = tag
            ? `组件 ${componentType.name} (tag=${tag}) 已经存在于当前状态中`
            : `组件 ${componentType.name} 已经存在于当前状态中`;
        super(msg, options);
    }
}
exports.GameComponentAlreadyExistsError = GameComponentAlreadyExistsError;
class ComponentLoadFailedError extends GameError_js_1.GameStateError {
    constructor(componentType, tag, options) {
        super(`组件 ${componentType.name} tag=${tag} 加载失败`, options);
    }
}
exports.ComponentLoadFailedError = ComponentLoadFailedError;
class ComponentDeleteFailedError extends GameError_js_1.GameStateError {
    constructor(componentType, tag, options) {
        super(`组件 ${componentType.name} tag=${tag} 卸载失败`, options);
    }
}
exports.ComponentDeleteFailedError = ComponentDeleteFailedError;
