"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SignClickEventSignal = void 0;
const server_1 = require("@minecraft/server");
const mapEventSignal_js_1 = require("../mapEventSignal.js");
class SignClickEventSignal extends mapEventSignal_js_1.BaseMapEventSignal {
    signId = "minecraft:wall_sign";
    buildKey(options) {
        const loc = options.loc;
        return `${options.dimensionId}-${loc.x}-${loc.y}-${loc.z}`;
    }
    buildData(callback, options) {
        return {
            callback,
            players: options.players,
            lastClick: server_1.system.currentTick,
            clickInterval: options.clickInterval ?? 1,
        };
    }
    extractKey(event) {
        const loc = event.block.location;
        return `${event.block.dimension.id}-${loc.x}-${loc.y}-${loc.z}`;
    }
    isTargetEvent(event) {
        return event.block.typeId === this.signId;
    }
    filter(data, event) {
        if (server_1.system.currentTick - data.lastClick < data.clickInterval) {
            return false;
        }
        if (data.players && !data.players.getById(event.player.id)) {
            return false;
        }
        data.lastClick = server_1.system.currentTick;
        return true;
    }
    subscribeNative(cb) {
        server_1.world.beforeEvents.playerInteractWithBlock.subscribe(cb);
        return cb;
    }
    unsubscribeNative(cb) {
        server_1.world.beforeEvents.playerInteractWithBlock.unsubscribe(cb);
    }
}
exports.SignClickEventSignal = SignClickEventSignal;
