"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntervalEventSignal = void 0;
const server_1 = require("@minecraft/server");
const index_js_1 = require("../../utils/index.js");
/** 间隔时间事件 */
class IntervalEventSignal {
    intervalId = null;
    items = new Set();
    logger = new index_js_1.Logger(this.constructor.name);
    subscribe(callback, interval) {
        //启动interval
        if (!this.intervalId)
            this.start();
        //添加到set
        const data = {
            callback: callback,
            interval: interval?.ticks ?? 0,
            tickCount: interval?.ticks ?? 1,
        };
        this.items.add(data);
        //返回取消订阅方法
        return {
            unsubscribe: () => this.items.delete(data),
        };
    }
    start() {
        this.intervalId = server_1.system.runInterval(() => this.tick());
    }
    tick() {
        for (const item of this.items) {
            item.tickCount--;
            if (item.tickCount <= 0) {
                try {
                    item.callback();
                }
                catch (e) {
                    this.logger.error("Interval callback error:", e);
                }
                item.tickCount = item.interval;
            }
        }
    }
    dispose() {
        if (this.intervalId !== null) {
            this.items.clear();
            server_1.system.clearRun(this.intervalId);
        }
    }
}
exports.IntervalEventSignal = IntervalEventSignal;
