"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RegionTeamCleaner = void 0;
const regionEvents_js_1 = require("../../gameEvent/events/regionEvents.js");
const main_js_1 = require("../../main.js");
const gameComponent_js_1 = require("../gameComponent.js");
/**玩家离开指定区域时将他从team移除 */
class RegionTeamCleaner extends gameComponent_js_1.GameComponent {
    onAttach() {
        if (!this.options)
            return;
        this.subscribe(main_js_1.Game.events.region, (t) => {
            if (t.type == regionEvents_js_1.RegionEventType.Leave) {
                this.options?.teams.forEach((team) => team.delete(t.player));
                this.options?.onClean?.(t.player);
            }
        }, this.options.region);
    }
}
exports.RegionTeamCleaner = RegionTeamCleaner;
