"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimerTickEventSignal = void 0;
const index_js_1 = require("../../../utils/index.js");
class TimerTickEventSignal {
    tickCallbacks = new Set();
    logger = new index_js_1.Logger(this.constructor.name);
    constructor() { }
    /** 注册一个在每次时间减少（每秒）时执行的回调函数*/
    subscribe(callback) {
        this.tickCallbacks.add(callback);
        return {
            unsubscribe: () => {
                this.tickCallbacks.delete(callback);
            },
        };
    }
    publish(remainingTime) {
        this.tickCallbacks.forEach((cb) => {
            try {
                cb({ remainingTime: remainingTime });
            }
            catch (err) {
                this.logger.error("timer Tick事件执行错误", err);
            }
        });
    }
}
exports.TimerTickEventSignal = TimerTickEventSignal;
