"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LazyLoader = void 0;
const server_1 = require("@minecraft/server");
const main_js_1 = require("../../main.js");
const index_js_1 = require("../../utils/index.js");
const gameComponent_js_1 = require("../gameComponent.js");
/**用于懒加载区块 */
class LazyLoader extends gameComponent_js_1.GameComponent {
    active = false;
    logger = new index_js_1.Logger(this.constructor.name);
    components = [];
    get isActive() {
        return this.active;
    }
    onAttach() {
        this.subscribe(main_js_1.Game.events.interval, () => {
            if (!this.options)
                return;
            const { dimensionId: dimension, pos, onLoad, onUnload, } = this.options;
            const load = server_1.world.getDimension(dimension).getBlock(pos);
            if (load) {
                if (!this.active) {
                    this.logger.log("load");
                    try {
                        onLoad(this);
                    }
                    catch (err) {
                        this.logger.error("onLoad error:", err);
                    }
                    this.active = true;
                }
            }
            else {
                if (this.active) {
                    this.logger.log("unload");
                    this.clearComponents();
                    try {
                        onUnload?.();
                    }
                    catch (e) {
                        this.logger.error("onUnload error", e);
                    }
                    this.active = false;
                }
            }
        }, this.options.interval ?? new index_js_1.Duration(20));
    }
    clearComponents() {
        //先取消所有订阅
        this.components.forEach((c) => {
            this.state.eventManager.unsubscribeBySubscriber(c);
        });
        //再删除所有组件
        this.components.forEach((c) => this.state.deleteComponent(c));
        this.components = [];
    }
    reload() {
        if (!this.options)
            return;
        const { onLoad, onUnload } = this.options;
        if (this.active) {
            onUnload?.();
            this.clearComponents();
            this.active = false;
        }
        onLoad(this);
        this.active = true;
    }
    addComponent(component, options) {
        this.state.addComponent(component, options);
        this.components.push(component);
        return this;
    }
}
exports.LazyLoader = LazyLoader;
