"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoStopComponent = void 0;
const main_js_1 = require("../../main.js");
const index_js_1 = require("../../utils/index.js");
/**在组中所有玩家寄了之后自动结束游戏 */
class AutoStopComponent extends main_js_1.GameComponent {
    onAttach() {
        if (!this.options)
            return;
        this.subscribe(main_js_1.Game.events.interval, this.tick.bind(this), new index_js_1.Duration(20));
    }
    tick() {
        let liveSize = 0;
        this.options.groupSet.getAllPlayers().forEach((p) => {
            if (p.ttl > 0)
                liveSize++;
            if (p.isValid) {
                p.ttl = p.initialTTL; //重置TTL
            }
            else if (p.ttl > 0) {
                p.ttl--; //下线的ttl减少
                if (this.options?.immediateDie)
                    p.ttl = 0;
                if (p.ttl == 0) {
                    this.options.onLeave?.(p);
                    //自动释放玩家
                    if (this.options?.shouldRelease)
                        main_js_1.Game.playerManager.releasePlayerFromGame(p.id, this.state.gameKey);
                }
            }
        });
        if (liveSize === 0) {
            this.options.onStopGame();
        }
    }
}
exports.AutoStopComponent = AutoStopComponent;
