"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Constants = exports.Dimensions = void 0;
const server_1 = require("@minecraft/server");
const deferredObject_js_1 = require("./utils/deferredObject.js");
const vanila_data_js_1 = require("./utils/vanila-data.js");
const { proxy: dims, setTarget } = (0, deferredObject_js_1.createDeferredObject)();
server_1.world.afterEvents.worldLoad.subscribe(() => {
    setTarget({
        Overworld: server_1.world.getDimension(vanila_data_js_1.DimensionIds.Overworld),
        Nether: server_1.world.getDimension(vanila_data_js_1.DimensionIds.Nether),
        End: server_1.world.getDimension(vanila_data_js_1.DimensionIds.End),
    });
});
exports.Dimensions = dims;
exports.Constants = {
    /**维度常量（游戏加载后可用） */
    dimension: dims,
};
