"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const colors_js_1 = require("./colors.js");
const util_1 = __importDefault(require("util"));
const utils = __importStar(require("./../utils/index.js"));
/**
 * 日志级别
 * @readonly
 * @enum {string}
 */
const LEVELS = {
    ERROR: 'ERROR',
    WARN: 'WARN',
    INFO: 'INFO',
    DEBUG: 'DEBUG'
};
/**
 * 日志颜色
 * @readonly
 * @type {Object<string, string>}
 */
const LEVEL_COLORS = {
    [LEVELS.ERROR]: colors_js_1.red,
    [LEVELS.WARN]: colors_js_1.yellow,
    [LEVELS.INFO]: colors_js_1.white,
    [LEVELS.DEBUG]: colors_js_1.cyan
};
class Logger {
    [util_1.default.inspect.custom] = this.toString;
    /**
     * 打印日志
     * @private
     * @param {string} tag - 日志标签
     * @param {string} level - 日志级别
     * @param {string} color - 颜色前缀
     * @param {Array<*>} msgs - 日志内容
     */
    #print(tag, level, color, msgs) {
        const time = new Date().toISOString();
        const msgStr = utils.toString(msgs);
        this.getConsole(level.toLowerCase(), `${color}[${level}] [${tag}] ${time}: ${msgStr} ${colors_js_1.reset}`);
    }
    getConsole(type, t) {
        switch (type) {
            case "error":
                console.error(t);
                break;
            case "info":
                console.info(t);
                break;
            case "warn":
                console.warn(t);
                break;
            case "debug":
                console.debug(t);
                break;
            default:
                console.info(t);
        }
    }
    /**
     * 错误日志
     * @param {string} tag - 日志标签
     * @param {...*} msgs - 日志内容
     */
    e(tag, ...msgs) {
        this.#print(tag, LEVELS.ERROR, LEVEL_COLORS[LEVELS.ERROR], msgs);
    }
    /**
     * 警告日志
     * @param {string} tag - 日志标签
     * @param {...*} msgs - 日志内容
     */
    w(tag, ...msgs) {
        this.#print(tag, LEVELS.WARN, LEVEL_COLORS[LEVELS.WARN], msgs);
    }
    /**
     * 信息日志
     * @param {string} tag - 日志标签
     * @param {...*} msgs - 日志内容
     */
    i(tag, ...msgs) {
        this.#print(tag, LEVELS.INFO, LEVEL_COLORS[LEVELS.INFO], msgs);
    }
    /**
     * 调试日志
     * @param {string} tag - 日志标签
     * @param {...*} msgs - 日志内容
     */
    d(tag, ...msgs) {
        this.#print(tag, LEVELS.DEBUG, LEVEL_COLORS[LEVELS.DEBUG], msgs);
    }
    /**
     * @returns {string}
     */
    toString() {
        return '[object Logger]';
    }
}
exports.default = new Logger();
