"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mcVersionGeter = void 0;
// 版本资源表
const VERSION_TABLE = require('./../data/version.json').version;
// 转字符串
const normalize = (v) => {
    return String(v || '')
        .trim();
};
const parts = (v) => {
    return normalize(v)
        .split('.')
        .slice(0, 3)
        .map((n) => parseInt(n, 10) || 0);
};
const compareVer = (a, b) => {
    const A = parts(a);
    const B = parts(b);
    for (let i = 0; i < 3; i++) {
        const a = A[i];
        const b = B[i];
        if (!a || !b)
            continue;
        if (a !== b)
            return a > b ? 1 : -1;
    }
    return 0;
};
const findMatch = (version) => {
    const v = normalize(version);
    for (const item of VERSION_TABLE) {
        // 遍历查找
        const [start, end] = item.range;
        if (compareVer(v, start) >= 0 && compareVer(v, end) <= 0) {
            return {
                item,
                match: 'exact',
                start,
                end
            };
        }
    }
    const sorted = [
        ...VERSION_TABLE
    ].sort((a, b) => compareVer(b.range[0], a.range[0]));
    for (const item of sorted) {
        if (compareVer(v, item.range[0]) >= 0) {
            return {
                item,
                match: 'fallback',
                start: item.range[0],
                end: item.range[1]
            };
        }
    }
    const last = sorted[sorted.length - 1];
    return {
        item: last,
        match: 'oldest',
        start: last.range[0],
        end: last.range[1]
    };
};
exports.mcVersionGeter = {
    /**
     * @param version Minecraft版本号
     * @param useBeta 是否返回Beta版本
     */
    ToServer(version, useBeta = false) {
        const { item, match, start, end } = findMatch(version);
        if (match !== 'exact')
            console.warn(`⚠️ 使用兼容版本 ${start}-${end}（输入：${version}）`);
        return useBeta ? item.beta.server : item.format.server;
    },
    /**
     * @param version Minecraft版本号
     * @param useBeta 是否返回Beta版本
     */
    ToServerUi(version, useBeta = false) {
        const { item, match, start, end } = findMatch(version);
        if (match !== 'exact')
            console.warn(`⚠️ 使用兼容版本 ${start}-${end}（输入：${version}）`);
        return useBeta ? item.beta.server_ui : item.format.server_ui;
    }
};
