"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ManiFest = void 0;
const build_g_config_json_1 = __importDefault(require("./build-g-config.json"));
const utils = __importStar(require("./../utils/index.js"));
const mcVersion_js_1 = require("./mcVersion.js");
const index_js_1 = require("./../uuid/index.js");
const path = __importStar(require("path"));
const config = build_g_config_json_1.default;
const isNonEmptyString = (str) => typeof str === 'string' && str.trim().length > 0;
class ManiFest {
    data;
    constructor(MblerConfig, type) {
        this.data = {
            format_version: 2,
            header: {
                name: MblerConfig.name,
                description: MblerConfig.description,
                uuid: (0, index_js_1.fromString)(MblerConfig.name, config[type].header),
                version: utils.ToArray(MblerConfig.version),
                min_engine_version: utils.ToArray(MblerConfig.mcVersion.toString()),
            },
            modules: [{
                    type: type,
                    uuid: (0, index_js_1.fromString)(MblerConfig.name, config[type].module),
                    description: `From Mbler`,
                    version: utils.ToArray(MblerConfig.version),
                }]
        };
        if (type === "data" && MblerConfig.script)
            this.processScriptConfig(MblerConfig, this.data);
    }
    processScriptConfig(data, manifest) {
        const { script } = data;
        if (!script)
            return;
        let entry = script.main || "index.js";
        // 如果是mcx，直接设为index.js，因为mcxLoad类会聚集mcx文件和其他文件将其编译输出到index.js
        if (entry?.endsWith(".mcx") && script.lang === "mcx")
            entry = "index.js";
        if (!isNonEmptyString(entry))
            throw new Error('Script main entry is missing or invalid');
        if (!manifest.dependencies)
            manifest.dependencies = [];
        manifest.dependencies.push({
            module_name: '@minecraft/server',
            version: mcVersion_js_1.mcVersionGeter.ToServer(data.mcVersion.toString(), Boolean(script.UseBeta))
        });
        manifest.modules.push({
            type: 'script',
            language: 'javascript',
            entry: path.join("scripts", entry).replace("\\", "/ "),
            uuid: (0, index_js_1.fromString)(data.name, config.ScriptId),
            version: utils.ToArray(data.version),
        });
        if (script.ui === true) {
            manifest.dependencies.push({
                module_name: '@minecraft/server-ui',
                version: mcVersion_js_1.mcVersionGeter.ToServerUi(data.mcVersion.toString(), Boolean(script.UseBeta))
            });
        }
        ;
        manifest.capabilities = ['script_eval'];
    }
    ;
}
exports.ManiFest = ManiFest;
