"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.GameEngine=void 0;const playerManager_js_1=require("./gamePlayer/playerManager.js"),main_js_1=require("./main.js"),GameError_js_1=require("./utils/GameError.js"),logger_js_1=require("./utils/logger.js");class GameEngine{stateStack=[];logger;context;playerManager;key;_isActive=!1;get isDaemon(){return!1}get isActive(){return this._isActive}get groupBuilder(){return this.playerManager.groupBuilder}constructor(t,e,s){this.playerManager=new playerManager_js_1.GamePlayerManager(t,e,this.isDaemon),this.key=e,this.context=this.buildContext(s??{}),this.logger=new logger_js_1.Logger(this.constructor.name),this._isActive=!0}pushState(t,e){if(!this.isActive)return this;this.logger.debug(`Pushing state: ${t.name}`);const s=new t(this,e);return this.stateStack.push(s),s.onEnter(),this}popState(){const t=this.stateStack.pop();t&&this.removeState(t)}resetState(t,e){this.logger.debug(`Setting root state to: ${t.name}`),this.clearStateStack(),this.pushState(t,e)}replaceFrom(t,e,s){this.logger.debug(`Replacing from ${t.constructor.name} with ${e.name}`);const a=this.stateStack.indexOf(t);if(-1===a)throw this.logger.error(`无法找到要替换的状态实例:${t.constructor.name}`),new GameError_js_1.GameEngineError("State to replace not found in stack.");for(;this.stateStack.length>a;){const t=this.stateStack.pop();this.removeState(t)}this.pushState(e,s)}clearStateStack(){for(;this.stateStack.length>0;)this.popState()}removeState(t){this.logger.debug(`Removing state: ${t.constructor.name}`),t._onExit()}getNextState(t){const e=this.stateStack.findIndex(e=>e===t);if(-1!=e&&this.stateStack.length>e+1)return this.stateStack[e+1]}getLastState(t){const e=this.stateStack.findIndex(e=>e===t);if(e>0)return this.stateStack[e-1]}getState(t){const e=this.stateStack.find(e=>e.constructor==t);if(e)return e}deleteState(t){const e=this.stateStack.findIndex(e=>e.constructor==t);if(-1!=e){const[t]=this.stateStack.splice(e,1);this.removeState(t)}}stats(t=!1){let e;const s=this.stateStack.map(t=>t.constructor.name),a=`§ePlayers§r: §a${this.playerManager.validSize}§r / §7${this.playerManager.size}`;if(t){const t=this.stateStack.map(t=>t.stats());e=s.length>0?`§eStates§r(${s.length}): \n    ${t.join("\n    ")}`:"§eStates§r: §7<empty>"}else e=s.length>0?`§eStates§r(${s.length}): §b${s.join(" §7| §b")}`:"§eStates§r: §7<empty>";return["",a,e].join("\n  ")}stopGame(){main_js_1.Game.manager.stopGameByKey(this.key)}onDispose(){this.logger?.debug("dispose"),this.playerManager.dispose(),this._isActive=!1,this.clearStateStack()}}exports.GameEngine=GameEngine;