/**
 * Entity 类：对 Minecraft 原生实体对象的封装，
 * 提供安全的 API 操作、属性代理同步、参数校验等功能。
 */
export class Entity {
    constructor(logger: any, source: any);
    logger: any;
    _source: any;
    data: {};
    /**
     * 摧毁实体（调用原生 kill() 方法）
     */
    kill(): void;
    /**
     * 给实体添加状态效果（如中毒、速度等）
     * @param {string | number} name - 效果 ID 或名称
     * @param {number} duration - 持续时间 ticks
     * @param {number} [strength] - 效果强度（0-255）
     * @param {boolean} [show] - 是否显示粒子效果
     */
    addEffect(name: string | number, duration: number, strength?: number, show?: boolean): void;
    /**
     * 给实体添加标签
     * @param {string} name - 标签名称
     */
    addTag(name: string): void;
    /**
     * 移除实体标签
     * @param {string} name - 标签名称
     * @returns 是否移除成功
     */
    removeTag(name: string): any;
    /**
     * 移除实体身上的某个效果
     * @param {string | number} name - 效果 ID 或名称
     */
    removeEffect(name: string | number): any;
    /**
     * 对实体造成伤害（来自某个实体）
     * @param {number} hurt - 伤害值
     * @param {string} cause - 伤害类型，参考 EntityDamageCause
     * @param {Entity} source - 伤害来源实体
     */
    damage(hurt: number, cause: string, source: Entity): void;
    /**
     * 对实体造成伤害（来自投射物实体）
     * @param {number} hurt - 伤害值
     * @param {Entity} source - 伤害来源（通常是玩家）
     * @param {Entity} projectile - 投射物实体（如箭矢）
     */
    damageByProjectile(hurt: number, source: Entity, projectile: Entity): void;
    /**
     * 检查当前封装的实体是否有效（未被销毁）
     */
    _checkClass(): void;
    /**
     * 检查伤害来源参数是否合法
     */
    _checkDamageParam(hurt: any, source: any): any;
    /**
     * 检查标签名称是否合法
     */
    _checkTagName(name: any): void;
    /**
     * 初始化需要同步的实体属性（部分只读）
     */
    _init(): void;
    /**
     * 尝试从原生实体获取某个属性，出错时返回 null
     */
    _static(name: any): any;
    /**
     * 用于同步静态属性，内部方法
     * @param {string} name - 名称
     * @param {string|number|boolean|object} defaultValue - 默认值
     * @param {Boolean} isOnlyRead - 是否只读
     */
    _staticSet(name: string, defaultValue: string | number | boolean | object, isReadOnly: any): void;
}
