declare namespace _default {
    namespace ui {
        let classic: {
            iconPath: {
                type: string;
                regex: RegExp;
            };
            text: {
                type: string;
            };
            ToggleOptions: {
                type: string;
                ObjectType: {
                    tooltip: string;
                    defaultValue: string;
                };
            };
            num: {
                type: string;
            };
            SliderOptions: {
                type: string;
                ObjectType: {
                    tooltip: string;
                    defaultValue: string;
                    valueStep: string;
                };
            };
            "textField opt": {
                type: string;
                ObjectType: {
                    tooltip: string;
                    defaultValue: string;
                };
            };
            "Arr-item": {
                type: string;
                regexFunc(msg: any): msg is any[];
            };
        };
        namespace FormTypes {
            export { ActionFormData as Action };
            export { ModalFormData as Modal };
            export { MessageFormData as Message };
        }
        let FormTypeArr: string[];
        namespace LayoutTypes {
            namespace Action {
                export { body };
                export { divider };
                export { label };
                export { button };
                export { header };
            }
            namespace Modal {
                export { body };
                export { divider };
                export { label };
                export namespace submit {
                    let source: string;
                    let param: string[];
                    let minPar: number;
                }
                export namespace slider {
                    let source_1: string;
                    export { source_1 as source };
                    let param_1: string[];
                    export { param_1 as param };
                    let minPar_1: number;
                    export { minPar_1 as minPar };
                }
                export namespace toggle {
                    let source_2: string;
                    export { source_2 as source };
                    let param_2: string[];
                    export { param_2 as param };
                    let minPar_2: number;
                    export { minPar_2 as minPar };
                }
                export { header };
                export { input };
                export { drop };
            }
            namespace Message {
                export { body };
                export { button as button1 };
                export { button as button2 };
            }
        }
    }
}
export default _default;
declare namespace body {
    let source_3: string;
    export { source_3 as source };
    let param_3: string[];
    export { param_3 as param };
}
declare namespace divider {
    let source_4: string;
    export { source_4 as source };
    let param_4: never[];
    export { param_4 as param };
}
declare namespace label {
    let source_5: string;
    export { source_5 as source };
    let param_5: string[];
    export { param_5 as param };
}
declare namespace button {
    let source_6: string;
    export { source_6 as source };
    let param_6: string[];
    export { param_6 as param };
    let minPar_3: number;
    export { minPar_3 as minPar };
}
declare namespace header {
    let source_7: string;
    export { source_7 as source };
    let param_7: never[];
    export { param_7 as param };
}
declare namespace input {
    let source_8: string;
    export { source_8 as source };
    let param_8: string[];
    export { param_8 as param };
    let minPar_4: number;
    export { minPar_4 as minPar };
}
declare namespace drop {
    let source_9: string;
    export { source_9 as source };
    let param_9: string[];
    export { param_9 as param };
    let minPar_5: number;
    export { minPar_5 as minPar };
}
