/**向量工具类，提供向量相关的操作方法 */
export class Vector3Utils {
    /**距离 */
    static distance(v1: any, v2: any): number;
    /**距离(不开根号) */
    static squaredDistance(v1: any, v2: any): number;
    /**将Vector3转为数组 */
    static toArray(vector: any): any[];
    /**转为字符串，用指定分隔符连接 */
    static toString(vector: any, sep?: string): string;
    /**将数组转为Vector3 */
    static fromArray(array: any): {
        x: any;
        y: any;
        z: any;
    };
    /**复制一个 */
    static clone(v: any): any;
    /**v1+v2 */
    static add(v1: any, v2: any): {
        x: any;
        y: any;
        z: any;
    };
    /**v1-v2 */
    static subtract(v1: any, v2: any): {
        x: number;
        y: number;
        z: number;
    };
    /**v1*n */
    static scale(v: any, times: any): {
        x: number;
        y: number;
        z: number;
    };
    /**v1==v2? */
    static isEqual(v1: any, v2: any): boolean;
    /**v1与v2在误差eps范围内相等? */
    static isApproxEqual(v1: any, v2: any, eps?: number): boolean;
    /**向量长度 */
    static length(v: any): number;
    /**点积 */
    static dot(v1: any, v2: any): number;
    /**叉积 */
    static cross(v1: any, v2: any): {
        x: number;
        y: number;
        z: number;
    };
    /**归一化向量 */
    static normalize(v: any): {
        x: number;
        y: number;
        z: number;
    };
    /**返回上方指定距离(默认1)的Vector */
    static above(v: any, step?: number): {
        x: any;
        y: any;
        z: any;
    };
    /**返回下方指定距离(默认1)的Vector */
    static below(v: any, step?: number): {
        x: number;
        y: number;
        z: number;
    };
    /**获取坐标所在方块的位置，即浮点数坐标向下取整后的整数坐标。 */
    static intPos(v: any): {
        x: number;
        y: number;
        z: number;
    };
}
