export class GameEngine {
    constructor(playerClass: any, key: any, config: any);
    stateStack: any[];
    logger: Logger;
    context: any;
    playerManager: GamePlayerManager<import("./main.js").GamePlayer>;
    key: any;
    _isActive: boolean;
    /**是否是常驻游戏（常驻游戏不会被game end结束) */
    get isDaemon(): boolean;
    get isActive(): boolean;
    /**玩家组构建器 */
    get groupBuilder(): import("./main.js").PlayerGroupBuilder<import("./main.js").GamePlayer>;
    /** 在栈顶添加一个新的子状态 */
    pushState(stateType: any, config: any): this;
    /** 移除栈顶的状态，返回到父状态 */
    popState(): void;
    /** 清空所有状态，并设置一个新的根状态 */
    resetState(stateType: any, config: any): void;
    /** 从指定的状态实例开始替换状态分支。*/
    replaceFrom(stateToReplace: any, newStateType: any, config: any): void;
    clearStateStack(): void;
    removeState(state: any): void;
    /**获取下一个state */
    getNextState(state: any): any;
    /**获取上一个state */
    getLastState(state: any): any;
    /**获取指定state */
    getState(stateType: any): any;
    /**删除指定state */
    deleteState(stateType: any): void;
    /**显示engine信息 */
    stats(detail?: boolean): string;
    stopGame(): void;
    onDispose(): void;
}
import { Logger } from "./utils/logger.js";
import { GamePlayerManager } from "./gamePlayer/playerManager.js";
