/**
 * 获取模块列表
 */
export declare function getModules(dirname: string): Promise<string[]>;
/**
 * 根据名称获取模块 Git URL
 */
export declare function getModuleGit(dirname: string, packName: string): Promise<string | null>;
/**
 * 添加包到依赖
 */
export declare function addPack(packName: string, dirname_: string, workDir: string): Promise<void>;
/**
 * 从包依赖中移除
 */
export declare function unaddPack(packName: string, dirname_: string, workDir: string): Promise<void>;
/**
 * 安装模块
 */
export declare function installModules(Dirname: string, workDir: string): Promise<void>;
/**
 * 卸载单个模块
 */
export declare function uninstallModule(packName: string, dirname: string): Promise<boolean>;
/**
 * 卸载模块
 */
export declare function unInstallModules(Dirname: string, workDir: string): Promise<void>;
/**
 * 获取资源配置
 */
export declare function getResConfig(dirname: string): Promise<Map<string, any>>;
/**
 * ModulePath 类 - 用于获取模块信息
 */
interface ModuleCacheItem {
    name: string;
    git: string;
}
declare class ModulePath {
    #private;
    dir: string;
    cache: ModuleCacheItem[];
    constructor(dirname: string);
    start(): Promise<void>;
    getGit(name: string): string | null;
    getAll(): string[];
}
/**
 * 获取模块信息
 */
export declare function getModuleInfo(dirname: string): Promise<ModulePath>;
export default class Module {
    static globalModuleDir: string;
    static Install(mod: Mod): Promise<InstallReturn>;
}
export interface Mod {
    name: string;
    git: string;
}
export interface InstallReturn {
    lastTip?: string;
    res: boolean;
}
export {};
