/**
 * 工具类：提供控制台交互功能，比如高亮菜单渲染、交互式选择等
 */
export declare class Input {
    /**
     * 渲染一个字符串数组，高亮当前选中的项
     * @param arr 菜单项数组
     * @param index 当前选中索引
     * @returns 格式化后的字符串
     */
    static render(arr: string[], index: number): string;
    /**
     * 提供一个交互式菜单选择器
     * @param tip 提示文本
     * @param arr 选项数组
     * @returns 用户选中的选项内容（Promise<string>）
     */
    static select(tip: string, arr: string[]): Promise<any>;
    /**
     * 注册一个全局任务，每次按键都会被调用
     * @param task 回调函数
     */
    static use(task: (name: string, ctrl: boolean, alt: boolean, raw: string) => void): void;
}
