import type { BuildData } from './index';
interface MblerConfig {
    name: string;
    description: string;
    version: string;
    mcVersion: string;
    ResDes?: {
        name?: string;
        version?: string;
    };
    subpack?: Record<string, string>;
    script?: {
        main?: string;
        lang?: string;
        UseBeta?: boolean;
        ui?: boolean;
    };
}
interface ManifestData {
    format_version: number;
    header: {
        name: string;
        description: string;
        uuid: string;
        version: number[];
        min_engine_version: number[];
    };
    modules: Array<{
        type: string;
        uuid: string;
        description?: string;
        version: number[];
        language?: string;
        entry?: string;
    }>;
    dependencies?: Array<{
        module_name: string;
        version: string;
    }>;
    subpack?: Array<{
        folder_name: string;
        name: string;
        memory_tier: number;
    }>;
    capabilities?: string[];
}
export declare class ManiFest {
    data: ManifestData;
    constructor(MblerConfig: MblerConfig | BuildData, type: string);
    processScriptConfig(data: MblerConfig | BuildData, manifest: ManifestData): void;
}
export {};
