import { BaseBuild } from './base.js';
import type { MblerConfigData } from './../types.js';
export interface BuildData extends MblerConfigData {
    ResDes?: {
        name: string;
        version: string;
    };
    subpack?: Record<string, string>;
    minify?: boolean;
}
export default class Build extends BaseBuild {
    #private;
    [x: string]: any;
    baseDir: string;
    baseModDir: string;
    gamelibModule: any;
    constructor(buildPath: string, baseDir: string);
    build(): Promise<void>;
    start(): Promise<void>;
    writeManifest(data: BuildData): Promise<void>;
    buildManifest(data: BuildData): Promise<any>;
    processResourceDependencies(data: BuildData, manifest: any): void;
    handleScripts(data: BuildData): Promise<void>;
    processSubpacks(data: BuildData): Promise<void>;
    compileTypeScriptUnified(): Promise<void>;
    handlerMod(modules: Record<string, string>, processed?: Set<string>): Promise<string[]>;
    handleIncludes(): Promise<void> | undefined;
    processMinification(data: BuildData): Promise<void>;
}
